## Function inputs: 	delta = non-inferiority margin for the trial
##						(se, fe, sc, fc) = hypothetical mypan trial dataset summarised by number of successes and failures on MMF and CYC
##						mycyc = vector containing summaries of mycyc data
##						priNormEC = normalising constant of prior density for (pE, pC)|zr, where zr = mycyc data
##						postNormEC = normalising constant of posterior density for (pE, pC)|zr, data, where zr = mycyc data and hypothetical mypan data
##						a, b = parameters of Beta(a, b) prior distribution of pC representing what is known without the MYCYC data
##						lCparam, lEparam = parameters (mean, variance) of normal prior distributions for lambdaC and lambdaE
##						mu, sigma2 = mean, variance of normal prior for theta representing what is known without the MYCYC data
##						postInd = logical variable determining whether calculate P{pE > pC - delta | zr, data} (if postInd =="T") and P{pE > pC - delta | zr} (if postInd =="F")
## Function returns: P{pE > pC - delta | zr, data} or P{pE > pC - delta | zr}

D2calcgamma <- function(delta, se, fe, sc, fc, mycyc, priNormEC, postNormEC, a, b, lCparam, lEparam, mu, sigma2, postInd){
	 
	gridc = seq(0.001, 0.999, by=0.001)
	midp1 = (0.00001 + 0.001)*0.5
	midp2 = (0.99999 + 0.999)*0.5
    gridc = append(c(0.00001, midp1), gridc)
    gridc = append(gridc, c(midp2, 0.99999))  
    lc = length(gridc)

    wc  = vector(mode="numeric", length=lc)
    wc[1] = (gridc[3]-gridc[1])/6.0
    wc[lc] = (gridc[lc] - gridc[lc-2])/6.0
    for(i in seq(2, lc-1, by=2)){
		wc[i] = 4*(gridc[i+1] - gridc[i-1])/6.0
	}
    for(i in seq(3, lc-2, by=2)){
    	wc[i] = (gridc[i+2] - gridc[i-2])/6.0
	} 
	
	gridea = gridc
	gridca = gridc
		
	int = vector(mode="numeric", length = lc)
	for(i in 1:lc){
		## for each mesh point for pc, integrate joint density over the interval [max{0, pc - delta}, 1]
   		low = max(0, gridc[i] - delta)
   		if(low <= 0){
   			gride = gridc 
   		}else{		
   			## create a mesh for pe over the interval [upp, 1] (which always has >= 3 points)
   			m = floor((0.999 - low)/0.002)
   			u1 = low + m*0.002
         	midp1 = (u1 + 0.99999)/2.0 	
     		gride = as.double(append(seq(low, u1, by = 0.001), append(c(midp1), 0.99999) ))
     	}
		le = length(gride)

 		we  = vector(mode="numeric", length=le)
  		we[1] = (gride[3]-gride[1])/6.0
  		we[le] = (gride[le] - gride[le-2])/6.0
 		for(j in seq(2, le-1, by=2)){
     		we[j] = 4*(gride[j+1] - gride[j-1])/6.0
		}
		if(le >= 5){
 			for(j in seq(3, (le-2), by=2)){
  				we[j] = (gride[j+2] - gride[j-2])/6.0
 		 	}
 		 }

		denspe = vector(mode = "numeric", length = le)	
		if(postInd){
    		const1 = dnorm(log(gridca*(1-gridc[i])/(gridc[i]*(1-gridca))), mean=lCparam[1], sd = sqrt(lCparam[2]))
    		dens = (gridca^(mycyc[1]-1))*((1 - gridca)^(mycyc[2]-1))*const1
    		intpca = sum(wc*dens)
			for(j in 1:le){
				## Evaluate joint prior density g(pC, pE|zr, data)
				const1 = dnorm(log(gridea*(1-gride[j])/(gride[j]*(1-gridea))), mean = lEparam[1], sd = sqrt(lEparam[2]))
    			dens = (gridea^(mycyc[3] - 1))*((1-gridea)^(mycyc[4]-1))*const1
				intpea = sum(wc*dens)
				const1 = dnorm(log(gride[j]*(1-gridc[i])/(gridc[i]*(1 - gride[j]))), mean = mu, sd = sqrt(sigma2))
    			denspe[j] = priNormEC*const1*intpca*intpea*dbeta(gridc[i], shape1=a, shape2=b)/(gride[j]*(1-gride[j]))
				denspe[j] = denspe[j]*(gride[j]^se)*((1-gride[j])^fe) 
			}
			int[i] = sum(we*denspe)*(gridc[i]^sc)*((1-gridc[i])^fc)*postNormEC
		}else{
			## Evaluate joint prior density g(pC, pE|zr)
  			const1 = dnorm(log(gridca*(1-gridc[i])/(gridc[i]*(1-gridca))), mean=lCparam[1], sd = sqrt(lCparam[2]))
    		dens = (gridca^(mycyc[1]-1))*((1 - gridca)^(mycyc[2]-1))*const1
    		intpca = sum(wc*dens)
  			for(j in 1:le){
  				const1 = dnorm(log(gridea*(1-gride[j])/(gride[j]*(1-gridea))), mean = lEparam[1], sd = sqrt(lEparam[2]))
    			dens = (gridea^(mycyc[3] - 1))*((1-gridea)^(mycyc[4]-1))*const1
				intpea = sum(wc*dens)
    			const1 = dnorm(log(gride[j]*(1-gridc[i])/(gridc[i]*(1 - gride[j]))), mean = mu, sd = sqrt(sigma2))
    			denspe[j] = priNormEC*const1*intpca*intpea*dbeta(gridc[i], shape1=a, shape2=b)/(gride[j]*(1-gride[j]))
  			}
  			int[i] = sum(we*denspe)	
		}
	}
	return(sum(wc*int))
}

## Function inputs: 	priNormEC = normalising constant of prior density for (pE, pC)|zr, where zr = mycyc data
##						postNormTC = normalising constant of posterior density for (theta, pC)|zr, data, where zr = mycyc data and data=hypothetical mypan dataset
##						(se, fe, sc, fc) = hypothetical mypan trial dataset summarised by number of successes and failures on MMF and CYC
##						mycyc = vector containing summaries of mycyc data
##						a, b = parameters of Beta(a, b) prior distribution of pC representing what is known without the MYCYC data
##						lCparam, lEparam = parameters (mean, variance) of normal prior distributions for lambdaC and lambdaE
##						mu, sigma2 = mean, variance of normal prior for theta representing what is known without the MYCYC data
##						thetaExp, thetaSD = expectation and SD of prior/posterior distribution of theta incorporating MYCYC data
##						postInd = logical variable determining whether calculate P{theta > 0| zr, data} (if postInd =="T") and P{theta > 0| zr} (if postInd =="F")
## Function returns: P{theta > 0| zr, data} or P{theta > 0| zr}

D2calcpi <- function(postNormTC, priNormEC, se, fe, sc, fc, a, b, lCparam, lEparam, mu, sigma2, mycyc, thetaExp, thetaSd, postInd){
  	
  	gridc = seq(0.001, 0.999, by=0.001)
	midp1 = (0.00001 + 0.001)*0.5
	midp2 = (0.99999 + 0.999)*0.5
    gridc = append(c(0.00001, midp1), gridc)
    gridc = append(gridc, c(midp2, 0.99999))  
    lc = length(gridc)

    wc  = vector(mode="numeric", length=lc)
    wc[1] = (gridc[3]-gridc[1])/6.0
    wc[lc] = (gridc[lc] - gridc[lc-2])/6.0
    for(i in seq(2, lc-1, by=2)){
		wc[i] = 4*(gridc[i+1] - gridc[i-1])/6.0
	}
    for(i in seq(3, lc-2, by=2)){
    	wc[i] = (gridc[i+2] - gridc[i-2])/6.0
	} 
	
	gridea = gridc
	gridca = gridc
	
	r = as.integer(16)
   	mesh = as.integer(6*r -1)
   	grid1 = vector(mode="numeric", length= mesh)
   	for(i in 1:mesh){
   		if(i <= (r-1)){
   			grid1[i] = thetaExp + thetaSd*(-3-4*log(r/i))
   		}else if((i >= r) & (i<= 5*r)){
   			grid1[i] = thetaExp + thetaSd*(-3 + 3*(i-r)/(2*r))
   		}else{
   			grid1[i] = thetaExp + thetaSd*(3 + 4*log(r/(6*r -i)))
   		}
   	}  
   	index = as.integer(1)
   	for(i in 1:mesh){
		if(grid1[i] <= 0.0){
   	  		grid1[i] = 0.0
   	  		index = i
   	  	}
    }
    if(grid1[mesh] == 0.0){
   	  	index = mesh-1
    	grid1[mesh] = 0.1
    }
   
   	## put reduced mesh in a new vector retaining only those points in the interval [0, infty)
   	mesh1 = as.integer(mesh - index+1)
   	grid2 = vector(mode="numeric", length= mesh1)
   	for(i in 1:mesh1){
   		grid2[i] = grid1[i + index-1]
   	}
   	mesh2 = as.integer(2*mesh1-1)
   	gridt = vector(mode="numeric", length= mesh2)
	## calculating the midpoints of grid2
	if(mesh1 >= 1){
		for(i in seq(1, mesh1, by=1)){
   	    	gridt[2*i-1] = grid2[i]	
   	  	}
   	  }
	if(mesh2-1 >= 2){
		for(i in seq(2, mesh2-1, by=2)){
   	  		gridt[i] = (gridt[i+1] + gridt[i-1])/2.0
   	  	} 
	}   
	## calculating Simpson's integration weights
   	wtheta  = vector(mode="numeric", length=mesh2)
    wtheta[1] = (gridt[3]-gridt[1])/6.0
  	wtheta[mesh2] = (gridt[mesh2] - gridt[mesh2-2])/6.0
  	for(i in seq(2, (mesh2-1), by=2)){
    	wtheta[i] = 4*(gridt[i+1] - gridt[i-1])/6.0
   	}
   	for(i in seq(3, (mesh2-2), by=2)){
		wtheta[i] = (gridt[i+2] - gridt[i-2])/6.0
   	}

	int = vector(mode="numeric", length=mesh1)
	denspc = vector(mode ="numeric", length=lc)
	if(postInd){
		for(i in 1:mesh2){
			for(j in 1:lc){
				## Evaluate joint prior density g(pC, theta |zr, data) where zr=mycyc data and data = hypothetical mypan trial dataset
				pe = gridc[j]*exp(gridt[i])/(gridc[j]*(exp(gridt[i]) -1) +1)
				const1 = dnorm(log(gridca*(1-gridc[j])/(gridc[j]*(1-gridca))), mean=lCparam[1], sd = sqrt(lCparam[2]))
    			dens = (gridca^(mycyc[1]-1))*((1 - gridca)^(mycyc[2]-1))*const1
    			intpca = sum(wc*dens)
    			
    			const1 = dnorm(log(gridea*(1-pe)/(pe*(1-gridea))), mean = lEparam[1], sd = sqrt(lEparam[2]))
    			dens = (gridea^(mycyc[3] - 1))*((1-gridea)^(mycyc[4]-1))*const1
				intpea = sum(wc*dens)
				const1 = dnorm(log(pe*(1-gridc[j])/(gridc[j]*(1 - pe))), mean = mu, sd = sqrt(sigma2))
    			denspc[j] = priNormEC*const1*intpca*intpea*dbeta(gridc[j], shape1=a, shape2=b)/(pe*(1-pe))		
    			
				denspc[j] = denspc[j]*(gridc[j]^(se+sc +1))*((1-gridc[j])^(fe+fc+1))
				denspc[j] = denspc[j]/((gridc[j]*(exp(gridt[i]) -1) +1)^(se+fe+2))
			}	
			int[i] = exp((se + 1)*gridt[i])*sum(wc*denspc)*postNormTC
		}
	}else{
		for(i in 1:mesh2){
  			## Integrate over joint density of (theta, pC)|zr	
  			int1 = (gridea^(mycyc[3] -1))*((1-gridea)^(mycyc[4]-1))
  			int2 = (gridea^(mycyc[1]-1))*((1-gridea)^(mycyc[2]-1))
  			for(j in 1:lc){
  				int3 = int1*dnorm(log(gridea*(1-gridc[j])/((1-gridea)*gridc[j]*exp(gridt[i]))), mean = lEparam[1], sd = sqrt(lEparam[2]))
  				int4 = int2*dnorm(log(gridea*(1-gridc[j])/((1-gridea)*gridc[j])), mean = lCparam[1], sd = sqrt(lCparam[2]))
  				denspc[j] = sum(wc*int3)*sum(wc*int4)*dbeta(gridc[j], shape1 = a, shape2=b)
  			}
  			int[i] = dnorm(gridt[i], mean=mu, sd = sqrt(sigma2))*priNormEC*sum(wc*denspc)
		}	
	}
	return(sum(wtheta*int))
}
